<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\FrontModule\Model\Carts;

class CartPreview extends BaseControl
{
	/** @var Carts */
	private $cartsService;

	/** @var Cart */
	private $cart;

	public function __construct(Carts $carts)
	{
		$this->cartsService = $carts;
	}

	public function render(): void
	{
		$this->template->setFile($this->getTemplateFile());
		$cart                       = $this->getCart();
		$this->template->itemsCount = $cart->getItemsCount();
		$this->template->itemsPrice = $cart->getPriceTotal();
		$this->template->render();
	}

	public function renderMobile(): void
	{
		$this->template->isMobile = true;
		$this->render();
	}

	protected function getCart(): Cart
	{
		if (!$this->cart) {
			$this->cart = $this->cartsService->getCurrentCart();
		}

		return $this->cart;
	}

	/*******************************************************************************************************************
	 * ============================== Signals
	 */

}

