<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\Event\ComponentTemplateEvent;
use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\CartFacade;

class OrderCartDetail extends BaseControl
{
	/** @var CartFacade */
	protected $cartFacade;

	public function __construct(CartFacade $cartFacade)
	{
		$this->cartFacade = $cartFacade;
	}

	/**
	 * zobrazeni kosiku na kazdem kroku objednavky
	 *
	 * @param array|null $discountCoupon
	 */
	public function render($discountCoupon = null): void
	{
		$cart                      = $this->cartFacade->getCart();
		$this->template->cart      = $cart;

		// TODO později odstranit
		if ($discountCoupon)
			$this->template->discountCoupon = $discountCoupon;

		$this->eventDispatcher->dispatch(new ComponentTemplateEvent($this->template, $this), 'eshopOrders.orderCartDetail.render');

		$this->template->render($this->getTemplateFile());
	}

	// TODO není potřeba
	public function renderSummary(): void
	{
		$this->template->setFile($this->getTemplateFile('CartDetailSummary', 'Order'));

		$cart                           = $this->cartFacade->getCart();
		$this->template->cartItems      = $cart->cartItems;
		$this->template->cartItemsPrice = $cart->getPriceTotal();

		$this->eventDispatcher->dispatch(new ComponentTemplateEvent($this->template, $this), 'eshopOrders.orderCartDetail.renderSummary');

		$this->template->render();
	}
}

