<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Entities\OrderDiscount;

class Discount implements IDiscount
{

	/** @var string */
	public $id;

	/** @var string */
	public $title;

	/** @var float */
	public $amount;

	/** @var float */
	public $amountInBaseCurrency;

	/** @var float */
	public $discount;

	/** @var string */
	public $type;

	/** @var string */
	public $typeSymbol;

	/** @var string */
	public $packageType;

	public function __construct(string $id, float $amount, string $type, string $packageType)
	{
		$this->id          = $id;
		$this->amount      = $amount;
		$this->type        = $type;
		$this->packageType = $packageType;
	}

	public function calculateDiscount(float $price, bool $useBaseCurrency = false): float
	{
		$amount = $useBaseCurrency ? $this->amountInBaseCurrency : $this->amount;
		if ($this->type == OrderDiscount::TYPE_PERCENT)
			$discount = -($price * ((float) $amount / 100));
		else
			$discount = -((float) $amount);

		if (!$useBaseCurrency)
			$this->discount = $discount;

		return $discount;
	}

	/**
	 * @return float
	 */
	public function getValue(): float
	{
		return $this->amount;
	}

	/**
	 * @return string
	 */
	public function getType(): string
	{
		return $this->type;
	}
}



