<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Core\Model\Entities\EntityManagerDecorator;
use Nette\Security\User as SUser;
use Users\Model\Users;

class OrderNewUserSubscriber implements EventSubscriberInterface
{
	/** @var  array */
	protected $conf;

	/** @var EntityManagerDecorator */
	protected $entityManager;

	/** @var SUser */
	protected $sUser;

	/** @var Users */
	protected $users;

	public function __construct(array $conf, EntityManagerDecorator $entityManager, SUser $user, Users $users)
	{
		$this->conf          = $conf;
		$this->entityManager = $entityManager;
		$this->sUser         = $user;
		$this->users         = $users;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => 'orderOnSuccess',
		];
	}

	public function orderOnSuccess(OrderEvent $orderEvent): void
	{
		if (!$this->sUser->isLoggedIn() && $this->conf['newUserEmailNotificationAfterOrder'] == true)
			$this->users->newUserEmailNotification($orderEvent->order->getCustomer()->getUser()->getId());
	}
}
