<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__cart_item")
 * @ORM\Entity
 */
class CartItem
{
	use TId;

	/** Identifikator slozeny z id produktu, varianty, a pripadne dalsich parametru, ktere maji vliv na cenu
	 * @var string
	 * @ORM\Column(name="ident", type="string", nullable=false)
	 */
	public $ident;

	/**
	 * @var int
	 * @ORM\Column(name="product_id", type="integer", nullable=true)
	 * TODO cizi klic (radeji bez entity) - a nebo opravdu pridat entitu a cizi klic? Pri smazani produktu smazat i polozku
	 */
	public $productId;

	/**
	 * @var int
	 * @ORM\Column(name="variant_id", type="integer", nullable=true)
	 */
	protected $variantId;

	/** pravdepodobne pomoci "use" ziskat entitu z jineho baliku
	 *
	 * @ var Product
	 */
	//public $product;

	/**
	 * @var int
	 * @ORM\Column(name="quantity", type="smallint")
	 */
	public $quantity;

	/**
	 * @var Cart
	 * @ORM\ManyToOne(targetEntity="Cart", inversedBy="cartItems")
	 * @ORM\JoinColumn(name="cart_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $cart;

	public function __construct($ident, $productId, $cart)
	{
		$this->ident     = $ident;
		$this->productId = $productId;
		$this->quantity  = 1;
		$this->cart      = $cart;
		$this->cart->addCartItem($this); //Při vytvoření nové položky košíku je potřeba ji přidat rovnou do Entity košíku. Jelikož Proxy Entity ji po vytvoření neobsahuje
	}

	/*****
	 * === Quantity
	 */

	public function setQuantity($quantity)
	{
		$this->quantity = $quantity && $quantity > 0 ? $quantity : null;
	}

	public function getQuantity() { return $this->quantity; }

	public function getProductId()
	{
		return $this->productId;
	}

	public function getCart(): Cart
	{
		return $this->cart;
	}

	public function setProductId($productId)
	{
		$this->productId = $productId;

		return $this;
	}

	public function setCart(Cart $cart)
	{
		$this->cart = $cart;

		return $this;
	}

	/*******
	 * === Variant
	 */

	public function getVariantId()
	{
		return $this->variantId;
	}

	public function setVariantId($variantId): CartItem
	{
		$this->variantId = is_numeric($variantId) ? $variantId : null;

		return $this;
	}

}
