<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__invoice_address")
 * @ORM\Entity
 */
class Address
{
	use TId;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $street;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $city;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $postal;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $country;

}
