<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__order_flag",
 *      uniqueConstraints={@ORM\UniqueConstraint(name="order_flag_unique",columns={"order_id", "type"} )}
 *	 )
 * @ORM\Entity
 */
class OrderFlag
{
	const TYPE_QUESTIONING	= 'agreed_questioning';
	
	use TId;
	
	/** druh priznaku (napr "agreed_questioning" - souhlas s dotaznikem spokojenosti)
	 * @var string
	 * @ORM\Column(name="type", type="string")
	 */
	protected $type;
	
	/**
	 * @var boolean
	 * @ORM\Column(name="state", type="boolean", nullable=true)
	 */
	protected $state;

	/**
	 * @var Order
	 * @ORM\ManyToOne(targetEntity="Order", inversedBy="orderFlags")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;

	public function __construct($type, $state, $order)
	{
		$this->type  = $type;
		$this->state = $state;
		$this->order = $order;
	}
	
	/*******
	 * === Type
	 */
	
	public function getType()
	{
		return $this->type;
	}
	
	public function setType($type): OrderFlag
	{
		$this->type = $type;
		return $this;
	}
	
	/*******
	 * === State
	 */
	
	public function getState()
	{
		return $this->state;
	}
	
	public function setState($state): OrderFlag
	{
		$this->type = $state;
		return $this;
	}
	
	/*******
	 * === Order
	 */
	
	public function getOrder(): Order
	{
		return $this->order;
	}

	public function setOrder(Order $order)
	{
		$this->order = $order;
		return $this;
	}
}

