<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/** podobne jako order_item, ale samostatna tabulka
 * @ORM\Table("eshop_orders__order_payment")
 * @ORM\Entity
 */
class OrderPayment
{
	use TId;

	/**
	 * @var Payment
	 * @ORM\ManyToOne(targetEntity="Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $payment;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $name;

	/**
	 * @var float
	 * @ORM\Column(name="price", type="decimal", precision=10, scale=2)
	 */
	protected $price;

	/**
	 * @var Order
	 * @ORM\OneToOne(targetEntity="Order", inversedBy="payment")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;

	public function __construct(Payment $payment, Order $order)
	{
		$this->payment = $payment;
		$this->name    = $payment->getName();
		$this->price   = $payment->getPrice();
		$this->order   = $order;
	}

	public function getPayment(): ?Payment { return $this->payment; }

	public function getName(): string { return $this->name; }

	public function setName(string $name): self
	{
		$this->name = $name;

		return $this;
	}

	public function getPrice(bool $useCurrency = false): float
	{
		return $useCurrency
			? $this->getOrder()->calculateCurrencyPrice((float) $this->price)
			: (float) $this->price;
	}

	public function setPrice(float $price): self
	{
		$this->price = $price;

		return $this;
	}

	public function getOrder(): Order { return $this->order; }
}
