<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__payment_spedition")
 * @ORM\Entity
 */
class PaymentSpedition
{
	use TId;

	/**
	 * @var Payment
	 * @ORM\ManyToOne(targetEntity="Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $payment;

	/**
	 * @var Spedition
	 * @ORM\ManyToOne(targetEntity="Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $spedition;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;

	/**
	 * @var Site
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", onDelete="CASCADE", nullable=true)
	 */
	public $site;

	public function __construct(Site $site)
	{
		$this->site        = $site;
		$this->isPublished = 1;
		$this->setPosition(-1);
	}

	/**
	 * @return Payment
	 */
	public function getPayment(): Payment
	{
		return $this->payment;
	}

	/**
	 * @param Payment $payment
	 *
	 * @return PaymentSpedition
	 */
	public function setPayment(Payment $payment): PaymentSpedition
	{
		$this->payment = $payment;

		return $this;
	}

	/**
	 * @return Spedition
	 */
	public function getSpedition(): Spedition
	{
		return $this->spedition;
	}

	/**
	 * @param Spedition $spedition
	 *
	 * @return PaymentSpedition
	 */
	public function setSpedition(Spedition $spedition): PaymentSpedition
	{
		$this->spedition = $spedition;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition(): int
	{
		return $this->position;
	}

	/**
	 * @param int $position
	 *
	 * @return PaymentSpedition
	 */
	public function setPosition(int $position): PaymentSpedition
	{
		$this->position = $position;

		return $this;
	}

}
