<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Sites;
use EshopOrders\Model\Entities\PaymentSpedition;
use Doctrine\ORM\Query\Expr\Join;
/**
 * class PaymentSpeditions
 * @package EshopOrders\Model
 *
 * @method PaymentSpedition|object|null getReference($id)
 * @method PaymentSpedition|null get($id)
 */
class PaymentSpeditions extends BaseEntityService
{
	protected $entityClass = PaymentSpedition::class;

	/** @var Sites @inject */
	public $sitesService;

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function setPublish($id, $state)
	{
		if ($item = $this->getReference($id)) {
			$item->isPublished = $state;
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @return PaymentSpedition[]
	 */
	public function getAllPublished(): array
	{
		return $this->getEr()->createQueryBuilder('ps', 'ps.id')
			->addSelect('site, p, s')
			->andWhere('ps.isPublished = :isPublished')
			->innerJoin('ps.site', 'site', Join::WITH, 'site.ident = :site')
			->innerJoin('ps.payment', 'p', Join::WITH, 'p.isPublished = :isPublished')
			->innerJoin('ps.spedition', 's', Join::WITH, 's.isPublished = :isPublished')
			->addOrderBy('s.position', 'ASC')
			->addOrderBy('p.position', 'ASC')
			->setParameters([
				'isPublished' => 1,
				'site'        => $this->sitesService->getCurrentSite()->getIdent(),
			])
			->getQuery()->getResult();
	}
}
