<?php declare(strict_types = 1);


namespace EshopOrders\AdminModule\Components\Customer;

use Core\Model\UI\BaseControl;
use EshopCatalog\Model\Config;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use EshopOrders\Model\Entities\GroupCustomers;

class GroupsCustomersGrid extends BaseControl
{
	/** @var GroupsCustomers */
	protected $groupsCustomersService;

	public function __construct(GroupsCustomers $groupsCustomers)
	{
		$this->groupsCustomersService = $groupsCustomers;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->groupsCustomersService->getEr()->createQueryBuilder('gc');
		$grid->setDataSource($qb);

		//Columns
		$grid->addColumnLink('short', 'eshopOrders.defaultGrid.short', 'Customers:editGroup');
		$grid->addColumnText('name', 'eshopOrders.defaultGrid.name');

		if (Config::load('enablePriceLevels', false))
			$grid->addColumnText('productsSale', 'eshopOrders.groupCustomer.productsSale')->setRenderer(function(GroupCustomers $row) {
				return $row->getProductsSale() ? number_format($row->getProductsSale(), 2, ',', ' ') . ' %' : '';
			});

		$grid->addColumnStatus('isPublished', 'default.isActive')->setAlign('center')
			->addOption(1, 'eshopOrders.defaultGrid.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'eshopOrders.defaultGrid.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];

		// Filter

		// Actions
		$grid->addAction('edit', '', 'Customers:editGroup')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax')->setConfirm('default.reallyDelete');

		// Columns prototype

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->groupsCustomersService->remove($id))
			$presenter->flashMessageSuccess('eshopCatalog.defaultGrid.removed');
		else
			$presenter->flashMessageDanger('eshopCatalog.defaultGrid.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();


		if ($this->groupsCustomersService->setPublish($id, $newStatus)) {
			$presenter->flashMessageSuccess('eshopOrders.defaultGrid.publishChanged');
		} else {
			$presenter->flashMessageDanger('eshopOrders.defaultGrid.publishChangeFailed');
		}

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
