<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;

class TodayOrders extends BaseEshopOrdersWidget implements IWidget
{
	protected string $gridSize = 'col-md-4 col-xxl-3';

	protected string $key = 'eshopOrdersTodayOrders';

	/** @var Statistics\Statistics|null @inject */
	public ?Statistics\Statistics $statistics = null;

	public function render()
	{
		$this->template->key   = $this->key;
		$this->template->icon  = 'fas fa-circle';
		$this->template->title = $this->t('eshopOrders.dashboardWidget.todayOrders.title');

		$data                  = $this->statistics->getTodayOrders();
		$this->template->value = $data['count'] . ' / ' . $this->priceFilter->format((float) $data['price']);

		$this->template->baseTemplate = $this->baseTemplate;
		$this->template->render($this->getTemplateFile());
	}
}
