<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Order\IOrderItemReviewsGridFactory;
use EshopOrders\AdminModule\Components\Order\OrderItemReviewsGrid;

class OrderItemReviewsPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopOrders.title.reviews', 'fas fa-star-half-alt');
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	public function createComponentReviewsGrid(IOrderItemReviewsGridFactory $factory): OrderItemReviewsGrid
	{
		return $factory->create();
	}

}