<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model\Dao;

class OrderItem
{
	public int     $id;
	public ?int    $productId;
	public ?string $code1        = null;
	public ?string $ean          = null;
	public string  $title;
	public int     $quantity     = 1;
	public float   $price;
	public float   $priceWithoutVat;
	public float   $recyclingFee = 0;
	public int     $vatRate      = 0;
	public array   $moreData     = [];
	public array   $uploads      = [];

	public function __construct(
		int    $id,
		string $title,
		int    $quantity,
		float  $price,
		float  $priceWithoutVat
	)
	{
		$this->id              = $id;
		$this->title           = $title;
		$this->quantity        = $quantity;
		$this->price           = $price;
		$this->priceWithoutVat = $priceWithoutVat;
	}
}
