<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="eshop_orders__carrier_history")
 * @ORM\Entity
 */
class CarrierHistory
{
	use TId;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $speditionName;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $numberPackage;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(type="datetime", nullable=false)
	 */
	public $created;

	/**
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Order $order;

	public function __construct(Order $order, string $speditionName, ?string $numberPackage)
	{
		$this->order = $order;
		$this->speditionName = $speditionName;
		$this->numberPackage = $numberPackage;
		$this->created = new DateTime;
	}

}