<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__invoice_customer")
 * @ORM\Entity
 */
class Customer
{
	use TId;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $firstName;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $lastName;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public $email;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public $phone;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $company;

	/**
	 * IČO
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $idNumber;

	/**
	 * DIČ
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $vatNumber;

	/**
	 * IČ DPH
	 * @ORM\Column(name="id_vat_number", type="string", length=255, nullable=true)
	 */
	public ?string $idVatNumber = null;

	/**
	 * @ORM\Column(name="validated_id_number", type="smallint", length=1, options={"default": 0})
	 */
	public int $validatedIdNumber = 0;

	/**
	 * @ORM\Column(name="validated_vat_number", type="smallint", length=1, options={"default": 0})
	 */
	public int $validatedVatNumber = 0;

	/**
	 * @var Address
	 * @ORM\OneToOne(targetEntity="Address", cascade={"persist"})
	 * @ORM\JoinColumn(name="address_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $address;

	/**
	 * Customer constructor.
	 *
	 * @param Address $address
	 */
	public function __construct(Address $address)
	{
		$this->address = $address;
	}

	/**
	 * @return Address
	 */
	public function getAddress(): Address
	{
		return $this->address;
	}

	public function getName(): string { return trim($this->firstName . ' ' . $this->lastName); }
}
