document.addEventListener('click', e => {
	const target = e.target;
	let el       = null;

	if (target.dataset.orderFormIcoLoad !== undefined) {
		el               = target;
		const idNumberEl = document.querySelector('[name="idNumber"]');
		const countryEl  = document.querySelector('[name="country"]');

		if (!idNumberEl.value || !countryEl.value)
			return;

		let errorAppended = false;
		const url         = el.dataset.orderFormIcoLoad + '?ico=' + idNumberEl.value + '&country=' + countryEl.value.toLowerCase();
		const errBtnHtml  = '<span class="frm__input-error frm__input-error-ico-load">' + el.dataset.errorText + '</span>';

		global.naja.makeRequest('get', url, {}, {
			history: false,
		}).then(data => {
			if (data.error === true && errorAppended === false) {
				target.outerHTML += errBtnHtml;
				errorAppended = true;
			} else {
				if (data.company)
					document.querySelector('[name="company"]').value = data.company;
				if (data.dic)
					document.querySelector('[name="vatNumber"]').value = data.dic;
				if (data.street)
					document.querySelector('[name="street"]').value = data.street;
				if (data.city)
					document.querySelector('[name="city"]').value = data.city;
				if (data.zip)
					document.querySelector('[name="postal"]').value = data.zip;

				let existErr = document.querySelector('.frm__input-error-ico-load');
				if (existErr) {
					existErr.remove();
					errorAppended = false;
				}
			}
		}).catch(err => {
			if (!document.querySelector('.frm__input-error-ico-load')) {
				target.outerHTML += errBtnHtml;
				errorAppended = true;
			}
		});
	}
});
