<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\ArrayHash;

class EnableInvoiceGenerationSwitch extends BaseControl
{
	public function __construct(
		protected Order $order,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addBool('enableInvoiceGeneration', '')
			->setDefaultValue($this->order->enableInvoiceGeneration)
			->setHtmlAttribute('onchange', 'this.form.submit()');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values): void {
			$this->order->enableInvoiceGeneration = (int) $values->enableInvoiceGeneration;
			$this->em->persist($this->order);
			$this->em->flush();

			$this->presenter->redirect('this');
		};

		return $form;
	}

}
