<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\Event\Event;
use Core\Model\UI\BaseControl;

class ExpeditionConfirm extends BaseControl
{
	public function render(): void
	{
		$this->eventDispatcher->dispatch(new Event(['template' => $this->template]), self::class . '::onRender');
		$this->template->render($this->getTemplateFile());
	}

	public function handleOpen(): void
	{
		$this->template->modalTitle = $this->t('eshopOrders.expeditionConfirm.title');
		$this->template->modal      = 'expeditionConfirm';
		$this->redrawControl('modal');
	}

}
