<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Model\Sites;
use EshopOrders\Model\EshopOrdersConfig;
use Override;

class SettingsForm extends DataForm
{

	public function __construct(
		public Sites $sitesService,
	)
	{
		parent::__construct();
	}

	#[Override]
	public function getDataForInputs(): array
	{
		$data = parent::getDataForInputs();

		foreach ($this->sitesService->getOptionsForSelect() as $site) {
			$data[] = [
				'name'      => $site . 'ReviewInformationPage',
				'title'     => [
					0 => 'eshopOrders.settings.reviewInformationPage',
				],
				'type'      => 'navByGroup',
				'showIf'    => EshopOrdersConfig::load('enableReviewInformationPage', false),
				'site'      => $site,
				'section'   => $site,
				'group'     => 'base',
				'groupName' => 'eshopOrders.settings.baseSettings',
			];
		}

		return $data;
	}

}
