<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\FrontModule\Model\EshopOrdersCache;
use EshopOrders\Model\Entities\Affiliate\AffiliateCampaign;
use Override;

/**
 * @method AffiliateCampaign|object|null getReference($id)
 * @method AffiliateCampaign[] getAll($id)
 * @method AffiliateCampaign|null get($id)
 */
class AffiliateCampaigns extends BaseEntityService
{
	protected $entityClass = AffiliateCampaign::class;

	protected ?array $cForSelectOption = null;

	public function __construct(
		protected EshopOrdersCache $eshopOrdersCache,
	)
	{
	}

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null) {
			$this->cForSelectOption = $this->getEr()->findPairs([], 'name') ?: [];
		}

		return $this->cForSelectOption;
	}

	#[Override]
	public function remove($id)
	{
		$result = parent::remove($id);

		$this->eshopOrdersCache->cleanAffiliate();

		return $result;
	}

}
