<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\FrontModule\Model\EshopOrdersCache;
use EshopOrders\Model\Entities\Affiliate\AffiliatePartner;
use Override;

/**
 * @method AffiliatePartner|object|null getReference($id)
 * @method AffiliatePartner[] getAll($id)
 * @method AffiliatePartner|null get($id)
 */
class AffiliatePartners extends BaseEntityService
{
	protected $entityClass = AffiliatePartner::class;

	protected ?array $cForSelectOption = null;

	public function __construct(
		protected EshopOrdersCache $eshopOrdersCache,
	)
	{
	}

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null) {
			$this->cForSelectOption = $this->getEr()->findPairs([], 'name') ?: [];
		}

		return $this->cForSelectOption;
	}

	#[Override]
	public function remove($id)
	{
		$result = parent::remove($id);

		$this->eshopOrdersCache->cleanAffiliate();

		return $result;
	}

}
