<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model\Event;

use EshopOrders\Model\Entities\Order;
use Symfony\Contracts\EventDispatcher\Event;

class OrdersNavigationEvent extends Event
{
	public ?Order $order = null;

	public function __construct(
		public array &$navigation,
	)
	{
	}

	/** @param string|array $link */
	public function addNavigation(string $title, $link, ?string $ico = null, ?string $class = null, array $security = []): void
	{
		$this->navigation[] = [
			'title'    => $title,
			'link'     => $link,
			'ico'      => $ico,
			'class'    => $class,
			'security' => $security,
		];
	}
}
