<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Core\Model\Sites;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Security\Passwords;

class AdminToolsPresenter extends BasePresenter
{
	public array $adminToolsUrlFiles = [];

	public function __construct(
		protected Sites $sites,
	)
	{
		parent::__construct();
	}

	public function renderDefault(): void
	{
		$this->template->adminToolsUrlFiles = $this->adminToolsUrlFiles;
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		if (!$this->getUser()->isAllowed('EshopCatalog:Admin:AdminTools', 'access')) {
			$this->error();
		}

		$this->setHeader('eshopOrders.title.adminTools', 'fa fa-tools');

		$password = new Passwords();
		$keys     = [];
		foreach ($this->sites->getSites() as $site) {
			$domains = [];
			foreach ($site->getDomains() as $domain) {
				if (!$domain->getDomain()) {
					continue;
				}

				$domains[] = $domain->getDomain();
			}

			$keys[$site->getIdent()] = [
				'ident'   => $site->getIdent(),
				'domains' => $domains,
				'key'     => $password->hash(EshopOrdersConfig::loadString('cronUrlHash') . $site->getIdent()),
			];
		}

		$this->template->keys = $keys;
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
}

