<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Invoice\IInvoicesGridFactory;
use EshopOrders\AdminModule\Components\Invoice\InvoicesGrid;
use EshopOrders\AdminModule\Model\Event\InvoiceRegenerateEvent;
use Override;

class InvoicePresenter extends BasePresenter
{
	#[Override]
	protected function startup(): void
	{
		parent::startup();
		$this->eventDispatcher->addListener('eshopOrders.afterSaveRegeneratedInvoice', function(InvoiceRegenerateEvent $event): void {
			$this['invoicesGrid']['grid']->reload();
		});
	}

	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.title.invoices', 'fa fa-shopping-cart');

		// invoice settings navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.invoiceSettings',
			'link'  => $this->link('InvoiceConfigs:default'),
			'ico'   => 'fas fa-cogs',
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	public function createComponentInvoicesGrid(IInvoicesGridFactory $factory): InvoicesGrid { return $factory->create(); }
}
