<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model\Dao;

class OrderItem
{
	public ?int    $productId         = null;
	public ?string $code1             = null;
	public ?string $ean               = null;
	public float   $recyclingFee      = 0;
	public int     $vatRate           = 0;
	public array   $moreData          = [];
	public array   $uploads           = [];
	public array   $sales             = [];
	public ?int    $orderItemParentId = null;
	public ?string $note              = null;
	public bool    $isEditablePackage = false;

	public function __construct(
		public int    $id,
		public string $title,
		public int    $quantity,
		public float  $price,
		public float  $priceWithoutVat,
	)
	{
	}
}
