<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Entities\OrderItem;
use Exception;

class OrdersItem
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
	)
	{
	}

	public function changePrice(int $orderId, int $itemId, float $price): bool
	{
		/** @var ?OrderItem $orderItem */
		$orderItem = $this->em->getRepository(OrderItem::class)->findOneBy([
			'order' => $orderId,
			'id'    => $itemId,
		]);

		if (!$orderItem) {
			return false;
		}

		try {
			$orderItem->setPrice($price);
			$this->em->persist($orderItem);
			$this->em->flush();

			return true;
		} catch (Exception) {
		}

		return false;
	}

	public function changeQuantity(int $orderId, int $itemId, int $quantity): bool
	{
		/** @var ?OrderItem $orderItem */
		$orderItem = $this->em->getRepository(OrderItem::class)->findOneBy([
			'order' => $orderId,
			'id'    => $itemId,
		]);

		if (!$orderItem) {
			return false;
		}

		try {
			$orderItem->setQuantity($quantity);
			$this->em->persist($orderItem);
			$this->em->flush();

			return true;
		} catch (Exception) {
		}

		return false;
	}

	public function removeItem(int $orderId, int $itemId): bool
	{
		/** @var ?OrderItem $orderItem */
		$orderItem = $this->em->getRepository(OrderItem::class)->findOneBy([
			'order' => $orderId,
			'id'    => $itemId,
		]);

		if (!$orderItem) {
			return false;
		}

		try {
			$this->em->remove($orderItem);
			$this->em->flush();

			return true;
		} catch (Exception) {
		}

		return false;
	}
}
