<?php declare(strict_types = 1);

namespace EshopOrders\Console\Stats;

use Doctrine;
use EshopOrders\AdminModule\Model\Statistics\Statistics;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshoporders:stats:generate-monthly')]
class GenerateMonthly extends Command
{
	public function __construct(
		public Statistics $statistics,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshoporders:stats:generate-monthly')->setDescription('');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('GENERATE MONTHLY STATS');

		try {
			$this->statistics->getMonthly(false);

			$output->writeLn('<info>[OK] - generated</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
