<?php declare(strict_types = 1);

namespace EshopOrders\CronModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Strings as CoreStrings;
use EshopOrders\Model\Entities\Order;

class Orders
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function ordersByDate(string $siteIdent, string $from, string $to): array
	{
		$orders = [];

		//		$ordersIterator = $this->em->getRepository(Order::class)->createQueryBuilder('o')
		//			->innerJoin('o.orderStatuses', 'os', Join::WITH, 'os.status = :status AND os.created >= :from AND os.created <= :to')
		//			->where('o.site = :site')
		//			->setParameters([
		//				'site' => $siteIdent,
		//				'from' => $from . ' 00:00:00',
		//				'to'   => $to . ' 23:59:59',
		//			])->getIterator();

		$i = 0;
		foreach ($this->em->getConnection()->executeQuery("SELECT os.order_id FROM eshop_orders__order_status os 
                INNER JOIN eshop_orders__order o ON o.id = os.order_id AND o.site_id = ?
                WHERE os.status_id = ?
                AND os.created >= ? AND os.created <= ?", [$siteIdent, 'created', $from . ' 00:00:00', $to . ' 23:59:59'])->iterateAssociative() as $row) {
			/** @var ?Order $order */
			$order = $this->em->getReference(Order::class, $row['order_id']);
			if (!$order) {
				continue;
			}

			$data = [
				'id'                                  => $order->getId(),
				'created'                             => $order->getCreatedTime() ? $order->getCreatedTime()->format('Y-m-d H:i:s') : null,
				'priceWithVat'                        => $order->getPrice(),
				'priceWithoutVat'                     => $order->getPriceWithoutVat(),
				'itemsPriceWithVatWithoutDiscount'    => $order->getPriceItems(),
				'itemsPriceWithoutVatWithoutDiscount' => $order->getItemsPriceWithoutVat(),
				'company'                             => '',
				'firstName'                           => '',
				'lastName'                            => '',
				'email'                               => '',
				'phone'                               => '',
				'customerId'                          => '',
				'customerGroup'                       => '',
				'customerType'                        => 'B2C',
				'payment'                             => '',
				'paymentId'                           => '',
				'spedition'                           => '',
				'speditionId'                         => '',
				'current'                             => $order->getCurrencyCode(),
			];

			$addrInv = $order->getAddressInvoice();
			if ($addrInv) {
				$data['company']   = $addrInv->getCompany();
				$data['firstName'] = $addrInv->getFirstName();
				$data['lastName']  = $addrInv->getLastName();
				$data['email']     = $addrInv->getEmail();
				$data['phone']     = $addrInv->getPhone();
			}

			$customer = $order->getCustomer();
			if ($customer) {
				$data['customerId'] = $customer->getId();

				if ($customer->getGroupCustomers()) {
					$data['customerGroup'] = $customer->getGroupCustomers()->name;
					$data['customerType']  = $customer->getGroupCustomers()->type ?: 'B2C';
				}
			}

			if ($order->getPayment()) {
				$data['payment']   = $order->getPayment()->getPayment() ? $order->getPayment()->getPayment()->getName() : $order->getPayment()->getName();
				$data['paymentId'] = $order->getPayment()->getPaymentId();
			}

			if ($order->getSpedition()) {
				$data['spedition']   = $order->getSpedition()->getSpedition() ? $order->getSpedition()->getSpedition()->getName() : $order->getSpedition()->getName();
				$data['speditionId'] = $order->getSpedition()->getSpeditionId();
			}

			$orders[] = $data;

			$i++;

			if ($i % 10 === 0) {
				$this->em->clear();
				gc_collect_cycles();
			}
		}

		$this->em->clear();
		gc_collect_cycles();

		return $orders;
	}
}
