<?php declare(strict_types = 1);

namespace EshopOrders\CronModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Http\CsvResponse;
use Doctrine\ORM\Query\Expr\Join;
use EshopOrders\Model\Entities\Affiliate\AffiliateOrder;
use EshopOrders\Model\Entities\Affiliate\AffiliatePartner;

class AffiliatePresenter extends BasePresenter
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function actionExportPartnerOrders(string $hash): void
	{
		$partner = $this->em->getRepository(AffiliatePartner::class)->findOneBy(['hash' => $hash]);

		if (!$partner) {
			$this->error('Partner not found');
		}

		$fp = fopen('php://memory', 'wb+');

		if (!$fp) {
			$this->error('Cannot open memory');
		}

		fputcsv($fp, ['orderId', 'email', 'partnerIdent', 'partnerName', 'campaignIdent', 'commission', 'orderValue', 'created', 'cancelled'], ';');

		foreach ($this->em->getRepository(AffiliateOrder::class)->createQueryBuilder('ao')
			         ->select('ao.id, IDENTITY(ao.order) as order, ao.email, ac.ident as campaignIdent, ao.value, ao.orderValue, ao.created, ao.cancelled')
			         ->innerJoin('ao.campaign', 'ac')
			         ->innerJoin('ac.partner', 'ap', Join::WITH, 'ap.id = :partnerId')
			         ->setParameter('partnerId', $partner->getId())
			         ->getQuery()->getScalarResult() as $row) {
			fputcsv($fp, [
				$row['order'],
				$row['email'],
				$partner->ident,
				$partner->name,
				$row['campaignIdent'],
				$row['value'],
				$row['orderValue'],
				$row['created'],
				$row['cancelled'],
			], ';');
		}

		rewind($fp);
		$data = stream_get_contents($fp);
		fclose($fp);

		CsvResponse::sendResponse('data.csv', (string) $data);
	}

	public function actionExportPartnerClicks(string $hash): void
	{
		$partner = $this->em->getRepository(AffiliatePartner::class)->findOneBy(['hash' => $hash]);

		if (!$partner) {
			$this->error('Partner not found');
		}

		$conn         = $this->em->getConnection();
		$campaignsIds = $conn->fetchFirstColumn('SELECT id FROM eshop_orders__affiliate_campaign WHERE partner_id = :partnerId', [
			'partnerId' => $partner->getId(),
		]);

		if (!$campaignsIds) {
			$this->error('No campaigns found');
		}

		$fp = fopen('php://memory', 'wb+');

		if (!$fp) {
			$this->error('Cannot open memory');
		}

		fputcsv($fp, ['date', 'clicks', 'campaignId'], ';');

		foreach ($conn->fetchAllAssociative("SELECT `date`, clicks, campaign_id FROM eshop_orders__affiliate_campaign_stat WHERE campaign_id IN (" . implode(',', $campaignsIds) . ")") as $row) {
			fputcsv($fp, [
				$row['date'],
				$row['clicks'],
				$row['campaign_id'],
			], ';');
		}

		rewind($fp);
		$data = stream_get_contents($fp);
		fclose($fp);

		CsvResponse::sendResponse('data.csv', (string) $data);
	}
}
