<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\UI\BaseControl;
use EshopCatalog\DI\EshopCatalogExtension;
use EshopCatalog\Model\Config as EshopCatalogConfig;
use EshopOrders\FrontModule\Model\CartHelper;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\Cart;
use Nette\Utils\Html;

class CartPreview extends BaseControl
{
	protected ?Cart $cart = null;

	public function __construct(
		protected Carts      $cartsService,
		protected CartHelper $cartHelper,
	)
	{
	}

	public function render(): void
	{
		if (
			class_exists(EshopCatalogExtension::class)
			&& EshopCatalogConfig::load('allowAddToCartOnlyForLoggedUsers')
			&& !$this->presenter->getUser()->isLoggedIn()
		) {
			return;
		}

		$this->template->setFile($this->getTemplateFile());
		$this->template->itemsCountRaw = $this->getCart()->getItemsCount();
		$this->template->itemsCount    = $this->getItemsCountFormatted();
		$this->template->itemsPrice    = $this->getPriceFormatted();

		$this->template->render();
	}

	public function renderMobile(): void
	{
		$this->template->isMobile = true;
		$this->render();
	}

	public function getItemsCountRaw(): int
	{
		return $this->getCart()->getItemsCount() ?: 0;
	}

	public function getPriceFormatted(): Html
	{
		return $this->cartHelper->getPriceFormatted(
			$this->getCart()->getPriceItems(),
			$this->getCart()->getPriceItemsWithoutVat(),
		);
	}

	public function getItemsCountFormatted(): Html
	{
		return $this->cartHelper->getItemsCountFormatted($this->getCart()->getItemsCount());
	}

	public function getCart(): Cart
	{
		if (!$this->cart instanceof Cart) {
			$this->cart = $this->cartsService->getCurrentCart();
		}

		return $this->cart;
	}
}
