<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopOrders\Model\EshopOrdersConfig;
use Override;

class Spedition extends BasePS
{
	public ?string $code1           = null;
	public ?string $code2           = null;
	public bool    $isPickup        = false;
	public bool    $isStorePickup   = false;
	public bool    $allowOversized  = false;
	public ?string $heurekaId       = null;
	public ?string $zboziId         = null;
	public ?string $googleId        = null;
	public ?string $idealoId        = null;
	public array   $freeForPayments = [];
	public ?float  $maxWeight       = null;
	public ?string $frontGroup      = null;

	/** @var SpeditionWeight[] */
	public array $weights = [];

	public function getFreeForPaymentsIds(): array { return array_map(static fn($a) => $a->getId(), $this->freeForPayments); }

	#[Override]
	protected function prepareActualPrice(?Cart $cart = null, bool $returnInBaseCurrency = false): float
	{
		$cart     = $cart ?: $this->cart;
		$freeFrom = $this->getFreeFrom();

		if ($freeFrom !== null && $freeFrom <= $cart->getPriceForFreeSpedition()) {
			return 0;
		}

		$freeDelivery = true;
		foreach ($cart->getCartItems() as $item) {
			if ($item->freeDelivery !== true) {
				$freeDelivery = false;
			}
		}

		if ($freeDelivery) {
			return 0;
		}

		$price = $returnInBaseCurrency ? $this->getPriceInBaseCurrency() : $this->getPrice();

		if (EshopOrdersConfig::load('speditions.allowWeights')) {
			$cartTotalWeight = $cart->getTotalWeightInKG();

			$selectedWeight = null;
			foreach ($this->weights as $weight) {
				if ($cartTotalWeight >= $weight->weightFrom) {
					$selectedWeight = $weight;
				} else {
					break;
				}
			}

			if ($selectedWeight) {
				$price += $returnInBaseCurrency ? $selectedWeight->priceInBaseCurrency : $selectedWeight->price;
			}
		}

		return $price;
	}
}
