<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopCatalog\Model\Config as EshopCatalogConfig;
use EshopOrders\FrontModule\Model\Dao\AddedCartItem;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;

class OrderFacade
{
	public function __construct(
		protected Orders         $orders,
		protected Carts          $carts,
		protected ProductsFacade $productsFacade,
	)
	{
	}

	public function repeatOrder(int $orderId): array
	{
		$result = [
			'status'      => 'ok',
			'added'       => 0,
			'notFound'    => 0,
			'notQuantity' => 0,
		];
		$order  = $this->orders->getDetail($orderId);
		$this->carts->clearCartItems();

		if ($order instanceof Order) {
			$products      = [];
			$orderProducts = $order->getOrderItems()->toArray();
			foreach ($orderProducts as $item) {
				/** @var OrderItem $item */
				if (!$item->getProduct()) {
					continue;
				}

				$products[$item->getId()] = $item->getProduct()->getId();
			}

			$products = $this->productsFacade->getProducts($products);

			foreach ($orderProducts as $item) {
				if (!$item->getProduct()) {
					continue;
				}

				$product = $products[$item->getProduct()->getId()];
				if (!$product) {
					$result['notFound']++;
					continue;
				}

				$data = [
					'quantity' => $item->getQuantity(),
				];

				if (
					EshopCatalogConfig::load('pseudoWarehouse')
					&& (!EshopCatalogConfig::load('allowWarehouseOverdraft') || !$product->getAvailability()->warehouseOverdraft)
					&& $item->getQuantity() > $product->getQuantity() + $product->getQuantityExternal()
				) {
					$result['notQuantity']++;
					$data['quantity'] = $product->getQuantity() + $product->getQuantityExternal();
				}

				if ($data['quantity'] > 0) {
					$ci            = new AddedCartItem();
					$ci->productId = $product->getId();
					$ci->quantity  = (int) $data['quantity'];
					$this->carts->addItem($ci);
					$result['added']++;
				}
			}
		}

		if ($result['added'] === 0) {
			$result['status'] = 'error';
		}

		return $result;
	}
}
