<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopGifts\DI\EshopGiftsExtension;
use EshopOrders\Model\Entities\Order;

class Orders extends BaseFrontEntityService
{
	/** @var string */
	public $entityClass = Order::class;

	public function __construct(
		protected ProductsFacade $productsFacade,
	)
	{
	}

	public function getDetail(int $id): ?Order
	{
		$qb = $this->getEr()->createQueryBuilder('o')
			->addSelect('c, pay, sped, disc, del, inv, oStat, stat, items, itemTexts, itemSales')
			->leftJoin('o.customer', 'c')
			->innerJoin('o.payment', 'pay')
			->innerJoin('o.spedition', 'sped')
			->leftJoin('o.orderDiscounts', 'disc')
			->leftJoin('o.addressInvoice', 'inv')
			->leftJoin('o.addressDelivery', 'del')
			->innerJoin('o.orderStatuses', 'oStat')
			->innerJoin('oStat.status', 'stat')
			->leftJoin('o.orderItems', 'items')
			->leftJoin('items.sales', 'itemSales')
			->leftJoin('items.orderItemTexts', 'itemTexts')
			->where('o.id = :id')->setParameter('id', $id);

		if (class_exists(EshopGiftsExtension::class)) {
			$qb->leftJoin('o.gifts', 'oGifts')
				->leftJoin('items.gifts', 'itemsGifts')
				->addSelect('oGifts, itemsGifts');
		}

		return $qb->getQuery()->getOneOrNullResult();
	}
}
