<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\Http\Session;
use Core\Model\UI\FrontPresenter;
use Currency\Model\Currencies;
use EshopOrders\FrontModule\Components\Order\OrderForm;
use EshopOrders\FrontModule\Model\Affiliate;
use EshopOrders\FrontModule\Model\Customers;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Http\Request;
use Nette\Http\Response;
use Nette\Utils\Json;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Event\UserEvent;

class PresenterSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Currencies $currenciesService,
		protected Customers  $customers,
		protected Session    $session,
		protected Request    $request,
		protected Response   $response,
		protected Affiliate  $affiliate,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::startup' => 'startup',
			'user.logout'                       => 'logout',
		];
	}

	public function startup(ControlEvent $event): void
	{
		if (EshopOrdersConfig::load('affiliate.enable')) {
			$utmMedium = $this->request->getQuery('utm_medium');

			if ($utmMedium === 'affiliate') {
				$utmSource   = $this->request->getQuery('utm_source');
				$utmCampaign = $this->request->getQuery('utm_campaign');

				if ($utmSource && $utmCampaign) {
					$baseData = $this->affiliate->getBaseData()[$utmSource][$utmCampaign] ?? null;

					if ($baseData) {
						$this->affiliate->addClick((int) $baseData['campaignId']);

						$this->response->setCookie(
							'affiliate',
							base64_encode(Json::encode([
								'partnerId'  => $baseData['partnerId'],
								'campaignId' => $baseData['campaignId'],
								'source'     => $utmSource,
								'campaign'   => $utmCampaign,
								'created'    => time(),
							])),
							0
						);
					}
				}
			}
		}
	}

	public function logout(UserEvent $event): void
	{
		$session                = $this->session->getSection(OrderForm::sessionNamespace);
		$session->orderFormData = [];
	}
}
