<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Components\OrderItemReviews\IOrderItemReviewFormFactory;
use EshopOrders\FrontModule\Components\OrderItemReviews\OrderItemReviewForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Orders;
use Nette\Application\Attributes\Persistent;
use Nette\Application\UI\Multiplier;

class OrderItemReviewsPresenter extends BasePresenter
{
	#[Persistent]
	public ?string $orderIdent = null;

	public function __construct(
		public Orders                 $orders,
		public EntityManagerDecorator $em,
	)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionGiveReviews(): void
	{
		$orderIdent = $this->getParameter('orderIdent');

		if (!$orderIdent) {
			$this->error();
		}

		$this->orderIdent = $orderIdent;
		$order            = $this->orders->getByIdent($orderIdent);

		if (!$order instanceof Order) {
			$this->error();
		}

		$this->template->order = $order;
	}

	public function createComponentOrderItemReviewForm(IOrderItemReviewFormFactory $factory): Multiplier
	{
		return new Multiplier(function($orderItemId) use ($factory): OrderItemReviewForm {
			/** @var OrderItem $orderItemRef */
			$orderItemRef = $this->em->getReference(OrderItem::class, (int) $orderItemId);

			return $factory->create($orderItemRef);
		});
	}

}
