<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191103135214 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_orders__invoice (id INT AUTO_INCREMENT NOT NULL, due_date DATETIME NOT NULL, ident VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL, UNIQUE INDEX ident_idx (ident), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_config (id INT AUTO_INCREMENT NOT NULL, numerical_series_id INT DEFAULT NULL, ident VARCHAR(255) NOT NULL, maturity INT NOT NULL, UNIQUE INDEX UNIQ_B245694017654C (numerical_series_id), UNIQUE INDEX UNIQ_B245694044E78B2 (ident), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__numerical_series (id INT AUTO_INCREMENT NOT NULL, prefix VARCHAR(255) NOT NULL, digits_count INT NOT NULL, start_number INT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__invoice_config ADD CONSTRAINT FK_B245694017654C FOREIGN KEY (numerical_series_id) REFERENCES eshop_orders__numerical_series (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__order ADD invoice_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07E2989F1FD FOREIGN KEY (invoice_id) REFERENCES eshop_orders__invoice (id) ON DELETE SET NULL');
		$this->addSql('CREATE UNIQUE INDEX UNIQ_2888C07E2989F1FD ON eshop_orders__order (invoice_id)');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07E2989F1FD');
		$this->addSql('ALTER TABLE eshop_orders__invoice_config DROP FOREIGN KEY FK_B245694017654C');
		$this->addSql('DROP TABLE eshop_orders__invoice');
		$this->addSql('DROP TABLE eshop_orders__invoice_config');
		$this->addSql('DROP TABLE eshop_orders__numerical_series');
		$this->addSql('DROP INDEX UNIQ_2888C07E2989F1FD ON eshop_orders__order');
		$this->addSql('ALTER TABLE eshop_orders__order DROP invoice_id');
	}
}
