<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191108120322 extends AbstractMigration
{
	protected static array $orderProductIds = [];

	#[Override]
	public function up(Schema $schema): void
	{
		self::$orderProductIds = $this->connection->fetchAllAssociative("SELECT id, product_id as product FROM eshop_orders__order_item");

		$this->addSql('ALTER TABLE eshop_orders__order_item DROP COLUMN product_id');
		$this->addSql('ALTER TABLE eshop_orders__order_item ADD COLUMN product_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__order_item ADD CONSTRAINT FK_C0EA013F4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_C0EA013F4584665A ON eshop_orders__order_item (product_id)');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$productIds = [];

		foreach ($this->connection->fetchAllAssociative("SELECT id FROM eshop_catalog__product") as $row) {
			$productIds[] = $row['id'];
		}

		foreach (self::$orderProductIds as $row) {
			if (!in_array($row['product'], $productIds)) {
				continue;
			}

			$this->connection->update('eshop_orders__order_item', [
				'product_id' => $row['product'],
			], [
				'id' => $row['id'],
			]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__order_item DROP FOREIGN KEY FK_C0EA013F4584665A');
		$this->addSql('DROP INDEX IDX_C0EA013F4584665A ON eshop_orders__order_item');
	}
}
