<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191112190924 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_orders__invoice_address (id INT AUTO_INCREMENT NOT NULL, street VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, postal VARCHAR(255) DEFAULT NULL, country VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_bank (id INT AUTO_INCREMENT NOT NULL, iban VARCHAR(255) DEFAULT NULL, swift VARCHAR(255) DEFAULT NULL, variable_symbol VARCHAR(255) DEFAULT NULL, bank_code VARCHAR(255) DEFAULT NULL, bank_account VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_customer (id INT AUTO_INCREMENT NOT NULL, address_id INT DEFAULT NULL, first_name VARCHAR(255) DEFAULT NULL, last_name VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, phone VARCHAR(255) DEFAULT NULL, company VARCHAR(255) DEFAULT NULL, id_number VARCHAR(255) DEFAULT NULL, vat_number VARCHAR(255) DEFAULT NULL, UNIQUE INDEX UNIQ_6D75759CF5B7AF75 (address_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_discount (id INT AUTO_INCREMENT NOT NULL, invoice_data_id INT DEFAULT NULL, code VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, value INT NOT NULL, price NUMERIC(10, 2) NOT NULL, type VARCHAR(255) NOT NULL, INDEX IDX_DAC4F9BC52C97EF (invoice_data_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_data (id INT AUTO_INCREMENT NOT NULL, customer_id INT DEFAULT NULL, supplier_id INT DEFAULT NULL, spedition_id INT DEFAULT NULL, payment_id INT DEFAULT NULL, invoice_id INT DEFAULT NULL, lang VARCHAR(255) NOT NULL, currency VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_DC25AF109395C3F3 (customer_id), UNIQUE INDEX UNIQ_DC25AF102ADD6D8C (supplier_id), UNIQUE INDEX UNIQ_DC25AF104181B5B0 (spedition_id), UNIQUE INDEX UNIQ_DC25AF104C3A3BB (payment_id), UNIQUE INDEX UNIQ_DC25AF102989F1FD (invoice_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_payment (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, price NUMERIC(10, 2) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_product (id INT AUTO_INCREMENT NOT NULL, invoice_data_id INT DEFAULT NULL, name VARCHAR(255) DEFAULT NULL, product_id INT NOT NULL, quantity INT DEFAULT 0 NOT NULL, price NUMERIC(10, 2) NOT NULL, vat_rate SMALLINT NOT NULL, image_base64 LONGTEXT DEFAULT NULL, INDEX IDX_FC43B76CC52C97EF (invoice_data_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_spedition (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, price NUMERIC(10, 2) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__invoice_supplier (id INT AUTO_INCREMENT NOT NULL, bank_id INT DEFAULT NULL, address_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, id_number VARCHAR(255) DEFAULT NULL, vat_number VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, is_payer_vat TINYINT(1) DEFAULT \'0\' NOT NULL, UNIQUE INDEX UNIQ_776697EB11C8FB41 (bank_id), UNIQUE INDEX UNIQ_776697EBF5B7AF75 (address_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__invoice_customer ADD CONSTRAINT FK_6D75759CF5B7AF75 FOREIGN KEY (address_id) REFERENCES eshop_orders__invoice_address (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_discount ADD CONSTRAINT FK_DAC4F9BC52C97EF FOREIGN KEY (invoice_data_id) REFERENCES eshop_orders__invoice_data (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data ADD CONSTRAINT FK_DC25AF109395C3F3 FOREIGN KEY (customer_id) REFERENCES eshop_orders__invoice_customer (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data ADD CONSTRAINT FK_DC25AF102ADD6D8C FOREIGN KEY (supplier_id) REFERENCES eshop_orders__invoice_supplier (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data ADD CONSTRAINT FK_DC25AF104181B5B0 FOREIGN KEY (spedition_id) REFERENCES eshop_orders__invoice_spedition (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data ADD CONSTRAINT FK_DC25AF104C3A3BB FOREIGN KEY (payment_id) REFERENCES eshop_orders__invoice_payment (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data ADD CONSTRAINT FK_DC25AF102989F1FD FOREIGN KEY (invoice_id) REFERENCES eshop_orders__invoice (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_product ADD CONSTRAINT FK_FC43B76CC52C97EF FOREIGN KEY (invoice_data_id) REFERENCES eshop_orders__invoice_data (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice_supplier ADD CONSTRAINT FK_776697EB11C8FB41 FOREIGN KEY (bank_id) REFERENCES eshop_orders__invoice_bank (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE eshop_orders__invoice_supplier ADD CONSTRAINT FK_776697EBF5B7AF75 FOREIGN KEY (address_id) REFERENCES eshop_orders__invoice_address (id) ON DELETE SET NULL');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__invoice_customer DROP FOREIGN KEY FK_6D75759CF5B7AF75');
		$this->addSql('ALTER TABLE eshop_orders__invoice_supplier DROP FOREIGN KEY FK_776697EBF5B7AF75');
		$this->addSql('ALTER TABLE eshop_orders__invoice_supplier DROP FOREIGN KEY FK_776697EB11C8FB41');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data DROP FOREIGN KEY FK_DC25AF109395C3F3');
		$this->addSql('ALTER TABLE eshop_orders__invoice_discount DROP FOREIGN KEY FK_DAC4F9BC52C97EF');
		$this->addSql('ALTER TABLE eshop_orders__invoice_product DROP FOREIGN KEY FK_FC43B76CC52C97EF');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data DROP FOREIGN KEY FK_DC25AF104C3A3BB');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data DROP FOREIGN KEY FK_DC25AF104181B5B0');
		$this->addSql('ALTER TABLE eshop_orders__invoice_data DROP FOREIGN KEY FK_DC25AF102ADD6D8C');
		$this->addSql('DROP TABLE eshop_orders__invoice_address');
		$this->addSql('DROP TABLE eshop_orders__invoice_bank');
		$this->addSql('DROP TABLE eshop_orders__invoice_customer');
		$this->addSql('DROP TABLE eshop_orders__invoice_discount');
		$this->addSql('DROP TABLE eshop_orders__invoice_data');
		$this->addSql('DROP TABLE eshop_orders__invoice_payment');
		$this->addSql('DROP TABLE eshop_orders__invoice_product');
		$this->addSql('DROP TABLE eshop_orders__invoice_spedition');
		$this->addSql('DROP TABLE eshop_orders__invoice_supplier');
	}
}
