<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200618082041 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_orders__seller_invoice_config (id INT AUTO_INCREMENT NOT NULL, seller_invoice_config_id INT DEFAULT NULL, seller_id INT DEFAULT NULL, INDEX IDX_49A86499D1912E82 (seller_invoice_config_id), UNIQUE INDEX UNIQ_49A864998DE820D9 (seller_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__seller_invoice_config ADD CONSTRAINT FK_49A86499D1912E82 FOREIGN KEY (seller_invoice_config_id) REFERENCES eshop_orders__invoice_config (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__seller_invoice_config ADD CONSTRAINT FK_49A864998DE820D9 FOREIGN KEY (seller_id) REFERENCES eshop_catalog__seller (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__invoice DROP FOREIGN KEY FK_6A239EC1F6BD1646');
		$this->addSql('ALTER TABLE eshop_orders__invoice ADD seller_id INT DEFAULT NULL, DROP site_id');
		$this->addSql('ALTER TABLE eshop_orders__invoice ADD CONSTRAINT FK_6A239EC1D48ECD5F FOREIGN KEY (seller_id) REFERENCES eshop_catalog__seller (id) ON DELETE CASCADE');
		$this->addSql('CREATE INDEX IDX_6A239EC1D48ECD5F ON eshop_orders__invoice (seller_id)');

		$this->addSql('DROP TABLE eshop_orders__site_invoice_config');
		$this->addSql('ALTER TABLE eshop_orders__invoice_config ADD corrective_tax_numerical_series_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__invoice_config ADD CONSTRAINT FK_B2456940ECFE0D10 FOREIGN KEY (corrective_tax_numerical_series_id) REFERENCES eshop_orders__numerical_series (id) ON DELETE CASCADE');
		$this->addSql('CREATE UNIQUE INDEX UNIQ_B2456940ECFE0D10 ON eshop_orders__invoice_config (corrective_tax_numerical_series_id)');

		$this->addSql('ALTER TABLE eshop_orders__invoice_bank ADD note VARCHAR(255) DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__invoice_product ADD code1 VARCHAR(255) DEFAULT NULL');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__invoice_bank DROP note');
		$this->addSql('ALTER TABLE eshop_orders__invoice_product DROP code1');

		$this->addSql('ALTER TABLE eshop_orders__invoice_config DROP FOREIGN KEY FK_B2456940ECFE0D10');
		$this->addSql('DROP INDEX UNIQ_B2456940ECFE0D10 ON eshop_orders__invoice_config');
		$this->addSql('ALTER TABLE eshop_orders__invoice_config DROP corrective_tax_numerical_series_id');

		$this->addSql('CREATE TABLE eshop_orders__site_invoice_config (id INT AUTO_INCREMENT NOT NULL, site_invoice_config_id INT DEFAULT NULL, site_id VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, INDEX IDX_4A5E462E9D952C71 (site_invoice_config_id), UNIQUE INDEX UNIQ_4A5E462EF6BD1646 (site_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('ALTER TABLE eshop_orders__site_invoice_config ADD CONSTRAINT FK_4A5E462E9D952C71 FOREIGN KEY (site_invoice_config_id) REFERENCES eshop_orders__invoice_config (id) ON UPDATE NO ACTION ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__site_invoice_config ADD CONSTRAINT FK_4A5E462EF6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON UPDATE NO ACTION ON DELETE CASCADE');
		$this->addSql('DROP TABLE eshop_orders__seller_invoice_config');
		$this->addSql('ALTER TABLE eshop_orders__invoice DROP FOREIGN KEY FK_6A239EC1D48ECD5F');
		$this->addSql('DROP INDEX IDX_6A239EC1D48ECD5F ON eshop_orders__invoice');
		$this->addSql('ALTER TABLE eshop_orders__invoice ADD site_id VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, DROP seller_id');
		$this->addSql('ALTER TABLE eshop_orders__invoice ADD CONSTRAINT FK_6A239EC1F6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON UPDATE NO ACTION ON DELETE CASCADE');
		$this->addSql('CREATE UNIQUE INDEX ident_idx ON eshop_orders__invoice (ident)');
		$this->addSql('CREATE INDEX IDX_6A239EC1F6BD1646 ON eshop_orders__invoice (site_id)');
	}
}
