<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210823073444 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__invoice_address ADD country_code VARCHAR(2) DEFAULT NULL');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$conn      = $this->connection;
		$countries = $conn->fetchAllAssociativeIndexed("SELECT name, id FROM core__country");

		foreach ($conn->fetchAllAssociative("SELECT id, country FROM eshop_orders__invoice_address WHERE country_code IS NULL") as $row) {
			if (!isset($countries[$row['country']])) {
				continue;
			}

			$conn->executeQuery("UPDATE eshop_orders__invoice_address SET country_code = ? WHERE id = ?", [$countries[$row['country']]['id'], $row['id']]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__invoice_address DROP country_code');
	}
}
