<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20221011143450 extends AbstractMigration
{
	protected array $texts = [];

	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->texts = $this->connection->fetchAllAssociative("SELECT id, name FROM eshop_orders__status");

		$this->addSql('CREATE TABLE eshop_orders__status_text (lang VARCHAR(2) NOT NULL, id VARCHAR(255) NOT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_CCA59FD4BF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__status_text ADD CONSTRAINT FK_CCA59FD4BF396750 FOREIGN KEY (id) REFERENCES eshop_orders__status (id) ON DELETE CASCADE');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach ($this->texts as $v) {
			$this->connection->insert('eshop_orders__status_text', [
				'id'   => $v['id'],
				'lang' => 'cs',
				'name' => $v['name'],
			]);
			$this->connection->insert('eshop_orders__status_text', [
				'id'   => $v['id'],
				'lang' => 'sk',
				'name' => $v['name'],
			]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_orders__status_text');
	}
}
