<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20221108140932 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_orders__customer_customer_address (customer_id INT NOT NULL, address_id INT NOT NULL, INDEX IDX_C2A2996F9395C3F3 (customer_id), INDEX IDX_C2A2996FF5B7AF75 (address_id), PRIMARY KEY(customer_id, address_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__customer_customer_address ADD CONSTRAINT FK_C2A2996F9395C3F3 FOREIGN KEY (customer_id) REFERENCES eshop_orders__customer (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__customer_customer_address ADD CONSTRAINT FK_C2A2996FF5B7AF75 FOREIGN KEY (address_id) REFERENCES eshop_orders__customer_address (id) ON DELETE CASCADE');

		$this->addSql('ALTER TABLE eshop_orders__customer_address DROP FOREIGN KEY FK_E2F76AF29395C3F3');
		$this->addSql('DROP INDEX IDX_E2F76AF29395C3F3 ON eshop_orders__customer_address');
		$this->addSql('ALTER TABLE eshop_orders__customer_address CHANGE customer_id customer_id INT UNSIGNED DEFAULT NULL');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach ($this->connection->fetchAllAssociative("SELECT id, customer_id FROM eshop_orders__customer_address") as $row) {
			$this->connection->insert('eshop_orders__customer_customer_address', [
				'customer_id' => $row['customer_id'],
				'address_id'  => $row['id'],
			]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_orders__customer_customer_address');
		$this->addSql('ALTER TABLE eshop_orders__customer_address CHANGE customer_id customer_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__customer_address ADD CONSTRAINT FK_E2F76AF29395C3F3 FOREIGN KEY (customer_id) REFERENCES eshop_orders__customer (id) ON UPDATE NO ACTION ON DELETE CASCADE');
		$this->addSql('CREATE INDEX IDX_E2F76AF29395C3F3 ON eshop_orders__customer_address (customer_id)');
	}
}
