<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20250123094043 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_orders__affiliate_campaign (id INT UNSIGNED AUTO_INCREMENT NOT NULL, partner_id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, ident VARCHAR(255) DEFAULT NULL, created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, export_hash VARCHAR(12) NOT NULL, commission INT DEFAULT 0 NOT NULL, INDEX IDX_81A6D8F9393F8FE (partner_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__affiliate_order (id INT UNSIGNED AUTO_INCREMENT NOT NULL, order_id INT NOT NULL, campaign_id INT UNSIGNED NOT NULL, created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, price NUMERIC(10, 2) NOT NULL, email VARCHAR(255) DEFAULT NULL, cancelled DATETIME DEFAULT NULL, INDEX IDX_9D5713568D9F6D38 (order_id), INDEX IDX_9D571356F639F774 (campaign_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__affiliate_partner (id INT UNSIGNED AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, ident VARCHAR(255) DEFAULT NULL, created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, default_commission INT DEFAULT 0 NOT NULL, hash VARCHAR(255) DEFAULT NULL, UNIQUE INDEX UNIQ_89EA2F8844E78B2 (ident), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__affiliate_campaign ADD CONSTRAINT FK_81A6D8F9393F8FE FOREIGN KEY (partner_id) REFERENCES eshop_orders__affiliate_partner (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__affiliate_order ADD CONSTRAINT FK_9D5713568D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id)');
		$this->addSql('ALTER TABLE eshop_orders__affiliate_order ADD CONSTRAINT FK_9D571356F639F774 FOREIGN KEY (campaign_id) REFERENCES eshop_orders__affiliate_campaign (id)');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__affiliate_order DROP FOREIGN KEY FK_9D571356F639F774');
		$this->addSql('ALTER TABLE eshop_orders__affiliate_campaign DROP FOREIGN KEY FK_81A6D8F9393F8FE');
		$this->addSql('DROP TABLE eshop_orders__affiliate_campaign');
		$this->addSql('DROP TABLE eshop_orders__affiliate_order');
		$this->addSql('DROP TABLE eshop_orders__affiliate_partner');
	}
}
