<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Affiliate;

use Core\Model\Entities\TIdUnsigned;
use DateTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__affiliate_campaign_stat')]
#[ORM\Entity]
class AffiliateCampaignStat
{
	use TIdUnsigned;

	#[ORM\JoinColumn(name: 'campaign_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: AffiliateCampaign::class, inversedBy: 'stats')]
	public AffiliateCampaign $campaign;

	#[ORM\Column(name: 'date', type: Types::DATE_MUTABLE, nullable: false)]
	public DateTime $date;

	#[ORM\Column(name: 'clicks', type: Types::INTEGER, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $clicks = 0;

	public function __construct(AffiliateCampaign $campaign, DateTime $date)
	{
		$this->campaign = $campaign;
		$this->date     = $date;
	}

}

