<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Affiliate;

use Core\Model\Entities\TIdUnsigned;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Random;

#[ORM\Table('eshop_orders__affiliate_partner')]
#[ORM\Entity]
class AffiliatePartner
{
	use TIdUnsigned;

	#[ORM\Column(name: 'name', type: Types::STRING, nullable: false)]
	public string $name;

	#[ORM\Column(name: 'ident', type: Types::STRING, nullable: true, unique: true)]
	public string $ident;

	#[ORM\Column(name: 'created', type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public DateTime $created;

	/** @var ArrayCollection<AffiliateCampaign> */
	#[ORM\OneToMany(mappedBy: 'partner', targetEntity: AffiliateCampaign::class)]
	public Collection $campaigns;

	#[ORM\Column(name: 'default_commission', type: Types::INTEGER, nullable: false, options: ['default' => 0])]
	public int $defaultCommission = 0;

	#[ORM\Column(name: 'hash', type: Types::STRING, length: 255, nullable: false)]
	public string $hash;

	public function __construct(string $name, string $ident)
	{
		$this->name      = $name;
		$this->ident     = $ident;
		$this->created   = new DateTime();
		$this->campaigns = new ArrayCollection();
		$this->hash      = Random::generate(12);
	}
}

