<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__group_param')]
#[ORM\Entity]
class GroupParam
{
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: GroupCustomers::class)]
	public GroupCustomers $group;

	#[ORM\Id]
	#[ORM\Column(name: '`key`', type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Column(name: '`value`', type: Types::TEXT, nullable: true)]
	public ?string $value = null;

	public function __construct(GroupCustomers $group, string $key)
	{
		$this->group = $group;
		$this->key   = $key;
		$group->getParams()->set($key, $this);
	}
}
