<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\PriceCalculator\PriceCalculatorDiscount;

#[ORM\Table('eshop_orders__invoice_discount')]
#[ORM\Entity]
class Discount implements IDiscount
{
	use TId;

	#[ORM\Column(type: Types::STRING)]
	public ?string $code = null;

	#[ORM\Column(name: 'name', type: Types::STRING)]
	public ?string $name = null;

	/** sleva v procentech nebo pevna castka
	 * @var int|float|null
	 */
	#[ORM\Column(type: Types::INTEGER)]
	public $value;

	/** vysledna sleva vypocitana z procent - zaporna hodnota
	 * @var float|string|null
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
	public $price;

	/** procenta / fixni castka
	 */
	#[ORM\Column(type: Types::STRING)]
	public ?string $type = null;

	#[ORM\JoinColumn(name: 'invoice_data_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: InvoiceData::class, cascade: ['persist'], inversedBy: 'discounts')]
	protected InvoiceData $invoiceData;

	public ?PriceCalculatorDiscount $priceCalculatorItem = null;

	public function __construct(InvoiceData $invoiceData)
	{
		$this->invoiceData = $invoiceData;
	}

	public function getValue(): float { return $this->value; }

	public function getType(): string { return $this->type; }

	public function calculateDiscount(float $price): float { return -abs((float) $this->value); }
}
