<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__invoice_supplier')]
#[ORM\Entity]
class Supplier
{
	use TId;

	#[ORM\Column(name: 'name', type: Types::STRING)]
	public ?string $name = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $idNumber = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $vatNumber = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $email = null;

	#[ORM\JoinColumn(name: 'bank_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\OneToOne(targetEntity: Bank::class, cascade: ['persist'])]
	public ?Bank $bank = null;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 0])]
	public int $isPayerVat = 0;

	#[ORM\JoinColumn(name: 'address_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\OneToOne(targetEntity: Address::class, cascade: ['persist'])]
	public ?Address $address = null;

	public function __construct(Bank $bank, Address $address)
	{
		$this->bank    = $bank;
		$this->address = $address;
	}

	public function getBank(): Bank { return $this->bank; }

	public function getAddress(): Address { return $this->address; }
}
