<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use DateTime;
use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__order_card_payment_token')]
#[ORM\Entity]
class OrderCardPaymentToken
{
	use TId;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	public Order $order;

	#[ORM\Column(name: 'note', type: Types::STRING, length: 255, nullable: true)]
	public ?string $note = null;

	#[ORM\Column(name: 'created', type: Types::DATETIME_MUTABLE)]
	protected DateTime $created;

	/** @var Collection<OrderCardPaymentHistory> */
	#[ORM\OneToMany(mappedBy: 'token', targetEntity: OrderCardPaymentHistory::class)]
	protected Collection $history;

	#[ORM\Column(name: 'param', type: Types::STRING, nullable: true)]
	public ?string $param = null;

	public function __construct(Order $order)
	{
		$this->order   = $order;
		$this->created = new DateTime();
		$this->history = new ArrayCollection();
	}

	public function getToken(): int { return $this->getId(); }

	public function getCreated(): DateTime { return $this->created; }

	/** @return Collection<OrderCardPaymentHistory> */
	public function getHistory() { return $this->history; }
}
